#include "vtk.hh"

main ()
{
  vtkRenderMaster rm;
  vtkRenderWindow *renWin=rm.MakeRenderWindow();
  vtkRenderer *aren=renWin->MakeRenderer();
  vtkRenderWindowInteractor *iren=renWin->MakeRenderWindowInteractor();

  // read laser data and render face
  vtkCyberReader cyber;
    cyber.SetFilename("fran_face");
    cyber.DebugOn();

  vtkPolyNormals normals;
    normals.SetInput(cyber.GetOutput());
    normals.DebugOn();

  vtkPolyMapper cyberMapper;
    cyberMapper.SetInput(normals.GetOutput());

  vtkActor cyberActor;
    cyberActor.SetMapper(cyberMapper);
    cyberActor.GetProperty()->SetColor(1,.5,.25);

  // create glyphs
  vtkMaskPoints ptMask;
    ptMask.SetInput(normals.GetOutput());
    ptMask.SetOnRatio(100);
    ptMask.RandomModeOn();

  vtkConeSource cone;
    cone.SetResolution(6);

  vtkTransform transform;
    transform.Translate(.5,0,0);

  vtkTransformPolyFilter transformF;
    transformF.SetInput(cone.GetOutput());
    transformF.SetTransform(transform);

  vtkGlyph3D glyph;
    glyph.SetInput(ptMask.GetOutput());
    glyph.SetSource(transformF.GetOutput());
    glyph.UseNormal();
    glyph.ScaleByVector();
    glyph.SetScaleFactor(.004);

  vtkPolyMapper spikeMapper;
    spikeMapper.SetInput(glyph.GetOutput());

  vtkActor spikeActor;
    spikeActor.SetMapper(spikeMapper);
    spikeActor.GetProperty()->SetColor(0,.79,.34);

  // render the actors
  aren->AddActors(&cyberActor);
  aren->AddActors(&spikeActor);
  aren->SetBackground(.1,.2,.4);

  renWin->Render();

  // interact with data
  iren->Start();
}
